/**********************************************************************************
 Persistence of Vision Ray Tracer Scene Description File
 File name   : RandomDistribution_test.pov
 Version     : 3.7
 Description : use of f_boxed() for gaussian distribution
               
 Date        : May 2013 / november 2017
 Author      : Christian Froeschlin / Thomas de Groot
 E-mail      : 
 
 Copyright (C) 2013. All rights reserved.
 Use and/or modification of this scene is free, except for commercial purposes.
 Commercial distribution is not allowed without written permission from the author.
**********************************************************************************/

// Render settings 3.7 (right-click on a line below):
// +w800 +h800 +a0.3 +am2 +bm2 +wt6

//=================================================================================
// VERSION AND GAMMA SWITCHES
//=================================================================================
#version 3.7;

//=================================================================================
// DEFAULTS AND INCLUDES
//=================================================================================
#default {pigment {rgb <1,0,0>}}
#default {finish {ambient 0}}
//#default {image_map {gamma srgb}}

#include "colors.inc"
#include "rand.inc"
#include "functions.inc"
#include "transforms.inc"
//#include "TdG_Textures.inc"

//=================================================================================
// SCENE SWITCHES
//=================================================================================
#declare PoF            = off;	// on/off switch for the Position Finder
#declare SeeScreen      = off;	// Gilles Tran's Viibility Test
#declare Rad            = on;		// Radiosity switch

#declare AspectRatio    = image_width/image_height;
#declare CamZoom        = 1;
#declare CamSky         = <0, 1, 0>;
#declare CamAng         = 70;	//39
#declare CamLoc         = <0, 1.25, -2>;
#declare CamLookAt      = <0.0, -0.0, 0.0>;


//=================================================================================
// GLOBAL SETTINGS
//=================================================================================
global_settings {
  assumed_gamma 1.0
  max_trace_level 5			//default [5]
  #if (Rad)
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.004          // end pretrace at this size
    count 35                      // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1                 // higher -> smoother, less accurate [1.8]
    recursion_limit 1             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .3           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    maximum_reuse 0.1							// new parameter 3.7 [0.2]
    brightness 1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    normal off                    // take surface normals into account [off]
    media off                     // take media into account [off]
    always_sample off             // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
  #end
  //noise_generator 2
}

//====================================================================================
// CAMERA AND LIGHT
//====================================================================================
#include "Gilles Tran\GT_VisibilityTest.mcr"

camera {
  location  CamLoc
  sky       CamSky  
  up        CamSky
  direction z*CamZoom
  right     x*AspectRatio
  angle     CamAng
  look_at   CamLookAt
}

background { color rgb 0 }

light_source {<0,0,0> White translate <2000, 2000, -2000> shadowless}

//Christian Froeschlin:
#declare NUM = 5000;
#local Type  = 1;

//use either of the following functions:
#declare f_distribution =
#if (Type = 0) 
  function {pow(f_boxed(x,y,z)*f_bozo(x*5, y*5, z*5),2)}
#else
  //function {pow(f_boxed(x,y,z),2)}
  //function {pow(f_cylindrical(x,y,z),2)}
  function {f_cylindrical(x,y,z)}
#end

#declare R = seed(42);

#declare I = 0;

// Just to visualize the probability in the background
plane {
  y,0
  pigment {
    function {f_distribution(x,y,z)}
  }
  finish {emission 1}
}

box {-1, 1 pigment {rgbt <1, 1, 0, 0.95>}}

// Actual placement
union {

#for (I, 0, NUM, 1)
  #declare X = 2*rand(R)-1;
  #declare Y = 2*rand(R)-1; //for a third dimension
  #declare Z = 2*rand(R)-1;
  #if (rand(R) < f_distribution(X,0,Z)) //change to > for concentrations at periphery
    sphere {<X,0,Z>, 0.005}
  #end
#end

  pigment {color rgb <1,0,0>}
  finish  {emission 1}
} 